/*
 * Decompiled with CFR 0.152.
 */
package org.sinytra.connector.transformer.patch;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.api.EnvironmentInterface;
import net.fabricmc.api.EnvironmentInterfaces;
import net.fabricmc.loader.api.FabricLoader;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.Handle;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.InvokeDynamicInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.sinytra.adapter.patch.analysis.selector.AnnotationHandle;
import org.sinytra.adapter.patch.analysis.selector.AnnotationValueHandle;
import org.sinytra.adapter.patch.api.ClassTransform;
import org.sinytra.adapter.patch.api.Patch;
import org.sinytra.adapter.patch.api.PatchContext;

public class EnvironmentStripperTransformer
implements ClassTransform {
    private static final String ENVIRONMENT_ANNOTATION = Type.getDescriptor(Environment.class);
    private static final String ENVIRONMENT_INTERFACE_DESCRIPTOR = Type.getDescriptor(EnvironmentInterface.class);
    private static final String ENVIRONMENT_INTERFACES_DESCRIPTOR = Type.getDescriptor(EnvironmentInterfaces.class);
    private static final EnvType CURRENT_ENV = FabricLoader.getInstance().getEnvironmentType();
    private static final String LAMBDA_PREFIX = "lambda$";

    @Override
    public Patch.Result apply(ClassNode classNode, @Nullable AnnotationValueHandle<?> annotation, PatchContext context) {
        boolean applied = EnvironmentStripperTransformer.stripEnvironmentInterface(classNode.interfaces, classNode.invisibleAnnotations);
        ArrayList<MethodNode> removeMethods = new ArrayList<MethodNode>();
        for (MethodNode method : classNode.methods) {
            if (!EnvironmentStripperTransformer.remove(method.invisibleAnnotations)) continue;
            removeMethods.add(method);
            removeMethods.addAll(EnvironmentStripperTransformer.getMethodLambdas(classNode, method));
            applied = true;
        }
        classNode.methods.removeAll(removeMethods);
        Iterator it = classNode.fields.iterator();
        while (it.hasNext()) {
            FieldNode field = (FieldNode)it.next();
            if (!EnvironmentStripperTransformer.remove(field.invisibleAnnotations)) continue;
            it.remove();
            applied = true;
        }
        return applied ? Patch.Result.APPLY : Patch.Result.PASS;
    }

    private static List<MethodNode> getMethodLambdas(ClassNode cls, MethodNode method) {
        ArrayList<MethodNode> list = new ArrayList<MethodNode>();
        for (AbstractInsnNode insn : method.instructions) {
            if (!(insn instanceof InvokeDynamicInsnNode)) continue;
            InvokeDynamicInsnNode indy = (InvokeDynamicInsnNode)insn;
            if (indy.bsmArgs.length < 3) continue;
            for (Object bsmArg : indy.bsmArgs) {
                String name;
                Handle handle;
                if (!(bsmArg instanceof Handle) || !(handle = (Handle)bsmArg).getOwner().equals(cls.name) || !(name = handle.getName()).startsWith(LAMBDA_PREFIX)) continue;
                cls.methods.stream().filter(m -> m.name.equals(name) && m.desc.equals(handle.getDesc())).findFirst().ifPresent(m -> {
                    list.add((MethodNode)m);
                    list.addAll(EnvironmentStripperTransformer.getMethodLambdas(cls, m));
                });
            }
        }
        return list;
    }

    private static boolean stripEnvironmentInterface(List<String> interfaces, @Nullable List<AnnotationNode> annotations) {
        if (annotations != null) {
            boolean removed = false;
            for (AnnotationNode annotation : annotations) {
                if ((!ENVIRONMENT_INTERFACE_DESCRIPTOR.equals(annotation.desc) || !EnvironmentStripperTransformer.stripInterface(interfaces, new AnnotationHandle(annotation))) && (!ENVIRONMENT_INTERFACES_DESCRIPTOR.equals(annotation.desc) || !EnvironmentStripperTransformer.stripInterfaces(interfaces, new AnnotationHandle(annotation)))) continue;
                removed = true;
            }
            return removed;
        }
        return false;
    }

    private static boolean stripInterfaces(List<String> interfaces, AnnotationHandle handle) {
        boolean removed = false;
        List annotations = handle.getValue("value").map(AnnotationValueHandle::get).orElse(List.of());
        for (AnnotationNode annotation : annotations) {
            removed |= EnvironmentStripperTransformer.stripInterface(interfaces, new AnnotationHandle(annotation));
        }
        return removed;
    }

    private static boolean stripInterface(List<String> interfaces, AnnotationHandle handle) {
        boolean strip = handle.getValue("value").map(h -> EnvironmentStripperTransformer.readEnvType((String[])h.get()) != CURRENT_ENV).orElse(false);
        if (strip) {
            Type itf = (Type)handle.getValue("itf").orElseThrow().get();
            interfaces.remove(itf.getInternalName());
            return true;
        }
        return false;
    }

    private static boolean remove(@Nullable List<AnnotationNode> annotations) {
        if (annotations != null) {
            for (AnnotationNode annotation : annotations) {
                if (!ENVIRONMENT_ANNOTATION.equals(annotation.desc) || !EnvironmentStripperTransformer.remove(annotation)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean remove(AnnotationNode node) {
        if (node.values.size() != 2) {
            throw new IllegalArgumentException("Unexpected " + node.values.size() + " values for annotation " + node.desc);
        }
        String[] args = (String[])node.values.get(1);
        EnvType type = EnvironmentStripperTransformer.readEnvType(args);
        return CURRENT_ENV != type;
    }

    private static EnvType readEnvType(String[] args) {
        if (args.length != 2) {
            throw new IllegalArgumentException("Unexpected size of annotation value array" + args.length);
        }
        String side = args[1];
        return EnvType.valueOf(side);
    }
}

